

varying vec4 color;
varying float NdotL;
flat varying vec3 torch;
varying vec4 lmtexcoord;
varying vec3 normal1;

flat varying vec3 ambientUp;
flat varying vec3 ambientDown;
flat varying vec3 ambientLeft;
flat varying vec3 ambientRight;
flat varying vec3 ambientB;
flat varying vec3 ambientF;
flat varying float ambientA;
flat varying vec4 sunColor;

const vec3 torchColor = vec3(3.000, 1.382, 0.408);
////
#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)

#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)
vec4 toClipSpace_dh(vec3 viewSpacePosition)
{
    return vec4(projMAD(dhProjection, viewSpacePosition), -viewSpacePosition.z);
}

vec3 applyDirectionalWeighting(vec3 center, vec3 left, vec3 right, vec3 up, vec3 down)
{
    float weightCenter = 0.4;     // Highest weight for the center
    float weightSides = 0.15;     // Equal, lower weight for left and right
    float weightVerticals = 0.15; // Equal, lower weight for up and down

    // Apply weights
    // return center;
    return center * weightCenter + (left + right) * weightSides + (up + down) * weightVerticals;
}

void calculateLighting1(out vec3 ambientUp, out vec3 ambientLeft, out vec3 ambientRight, out vec3 ambientB,
                        out vec3 ambientF, out vec3 ambientDown, out float ambientA, out vec4 sunColor)
{
    float sunVis = clamp(sunElevation, 0.0, 0.05) / 0.05 * clamp(sunElevation, 0.0, 0.05) / 0.05;
    sunColor = vec4(sunLight, sunVis);

    float lightDir = float(sunVis >= 1e-5) * 2.0 - 1.0;

    // Up
    vec3 up = vec3(0.0, 1.0, 0.0);
    vec3 down = vec3(0.0, 1.0, 0.0);

    // Left, sorted by tilt
    vec3 left = vec3(-1.0, 0.0, 0.0);
    vec3 left_50_up = vec3(-1.0, 0.5, 0.0);

    // Forward, sorted by tilt
    vec3 forward = vec3(0.0, 0.0, 1.0);
    vec3 forward_50_up = vec3(0.0, 0.5, 1.0);

    // Right, sorted by tilt
    vec3 right = vec3(1.0, 0.0, 0.0);
    vec3 right_50_up = vec3(1.0, 0.5, 0.0);

    // Backward, sorted by tilt
    vec3 backward = vec3(0.0, 0.0, -1.0);
    vec3 backward_50_up = vec3(0.0, 0.5, -1.0);

    // vec3 upS = skyFromTex2(up, colortex6).rgb;
    vec3 upS = skyFromTex2(up, colortex6).rgb;

    vec3 downS = skyFromTex2(down, colortex6).rgb;

    vec3 leftS0 = skyFromTex2(left, colortex6).rgb;
    vec3 leftS = skyFromTex2(left_50_up, colortex6).rgb;

    vec3 rightS0 = skyFromTex2(right, colortex6).rgb;
    vec3 rightS = skyFromTex2(right_50_up, colortex6).rgb;

    vec3 frontS0 = skyFromTex2(forward, colortex6).rgb;
    vec3 frontS = skyFromTex2(forward_50_up, colortex6).rgb;

    vec3 backS0 = skyFromTex2(backward, colortex6).rgb;
    vec3 backS = skyFromTex2(backward_50_up, colortex6).rgb;

    ambientUp = applyDirectionalWeighting(upS, leftS, rightS, frontS, backS);
    ambientDown = applyDirectionalWeighting(downS, leftS, rightS, frontS, backS);

    ambientLeft = applyDirectionalWeighting(leftS, upS, leftS0, frontS, backS);

    ambientRight = applyDirectionalWeighting(rightS, upS, rightS0, frontS, backS);

    ambientF = applyDirectionalWeighting(frontS, upS, frontS0, leftS, rightS);

    ambientB = applyDirectionalWeighting(backS, upS, backS0, leftS, rightS);

    ambientA = luma((ambientUp + ambientLeft + ambientRight + ambientB + ambientF + ambientDown) / 6);
}

void main()
{
    lmtexcoord.xyzw = vec4(gl_MultiTexCoord0.xy, gl_MultiTexCoord1.xy);
    color = gl_Color;

    vec3 normal = gl_NormalMatrix * gl_Normal;
    normal1 = gl_Normal;
    torch = (pow(gl_MultiTexCoord1.x, 3.0) * 0.5) * torchColor * 0;

    calculateLighting1(ambientUp, ambientLeft, ambientRight, ambientB, ambientF, ambientDown, ambientA, sunColor);

    NdotL = clamp(dot(normal, sunVec), 0.0, 1.0);

    vec3 position = mat3(gl_ModelViewMatrix) * gl_Vertex.xyz + gl_ModelViewMatrix[3].xyz;

    gl_Position = taaFunc(toClipSpace_dh(position));
    // gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
}
